package de.avm.android.fritzapp;

import android.app.Application;

import de.avm.android.tr064.Tr064Log;
import de.avm.fundamentals.logger.FileLog;
import de.avm.fundamentals.utils.AvmUncaughtExceptionHandler;
import de.avm.fundamentals.utils.Utils;

public class FonApplication extends Application
{
	@Override
	public void onCreate()
	{
		super.onCreate();

		FileLog.instantiate(getApplicationContext());
        Utils.trackAppVersion(getApplicationContext());
        Thread.setDefaultUncaughtExceptionHandler(new AvmUncaughtExceptionHandler());
        Tr064Log.setLogListener(new Tr064LogListener());
	}

    private static class Tr064LogListener implements Tr064Log.LogListener
    {
        public void i(String tag, String message)
        {
            FileLog.i(tag, message);
        }

        public void i(String tag, String message, Throwable e)
        {
            FileLog.i(tag, message, e);
        }

        public void d(String tag, String message)
        {
            FileLog.d(tag, message);
        }

        public void d(String tag, String message, Throwable e)
        {
            FileLog.d(tag, message, e);
        }

        public void w(String tag, String message)
        {
            FileLog.w(tag, message);
        }

        public void w(String tag, String message, Throwable e)
        {
            FileLog.w(tag, message, e);
        }

        public void e(String tag, String message)
        {
            FileLog.e(tag, message);
        }

        public void e(String tag, String message, Throwable e)
        {
            FileLog.e(tag, message, e);
        }
    }
}
