/*
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License ("License") as
 * published by the Free Software Foundation  (version 3 of the License).
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap.tam;

import java.io.IOException;

import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.model.UnsignedNumber;
import de.avm.android.tr064.soap.ISoapCredentials;

public class SetEnable extends TamSoapHelper<Boolean>
{
    private int mIndex;
    private boolean mEnable;

    public SetEnable(ISoapCredentials soapCredentials, int index, boolean enable)
    {
        super(soapCredentials);
        UnsignedNumber.validateUi2(index, "index");
        mIndex = index;
        mEnable = enable;
    }

    public int getIndex()
    {
        return mIndex;
    }

    /**
     * @param index
     * 		Index of entry
     * @throws IllegalArgumentException
     * 		illegal value of index
     */
    public SetEnable setIndex(int index)
    {
        UnsignedNumber.validateUi2(index, "index");
        mIndex = index;
        return this;
    }

    public boolean isEnable()
    {
        return mEnable;
    }

    public SetEnable setEnable(boolean enable)
    {
        mEnable = enable;
        return this;
    }

    @Override
    public String getSoapMethod()
    {
        return "SetEnable";
    }

    @Override
    public String getSoapMethodParameter()
    {
        return "<NewIndex>" + Integer.toString(mIndex) + "</NewIndex>" +
                "<NewEnable>" + Integer.toString((mEnable) ? 1 : 0) + "</NewEnable>";
    }

    @Override
    public Boolean getQualifiedResult() throws IOException, BaseException
    {
        exceptOnFault(getSoapBody());
        return Boolean.TRUE;
    }
}
